#pragma once

#include <folly/synchronization/Baton.h>
#include <wangle/channel/Handler.h>

namespace rtransfer {

/**
 * When this handler learns that the pipeline stopped, it signals a baton.
 * We use this helper on top of stdin, and we wait for the baton in `main()` -
 * the idea is than when stdin closes, `main()` stops its wait and finishes,
 * closing the application.
 */
class StopBatonHandler : public wangle::BytesToBytesHandler {
public:
    explicit StopBatonHandler(folly::Baton<> &baton)
        : baton_{baton}
    {
    }

    void readEOF(Context * /*ctx*/) override { baton_.post(); }

private:
    folly::Baton<> &baton_;
};

}  // namespace rtransfer
