#pragma once

#include <folly/FBVector.h>

#include <chrono>
#include <condition_variable>
#include <mutex>
#include <queue>
#include <thread>

namespace rtransfer {

class Shaper;

/**
 * We need something more precise than a HHWheelTimer offered by folly in order
 * to wake up a shaper after the set amount of time. We want to minimize the
 * delay, and the next best thing to a busy wait (which has a microsecond
 * precision, so it would be great if it didn't use up CPU) is a timed wait on a
 * condition.
 */
template <class Clock>
class ShaperTimer {
public:
    ShaperTimer();

    ~ShaperTimer();

    ShaperTimer(const ShaperTimer &) = delete;
    ShaperTimer(ShaperTimer &&) = delete;
    ShaperTimer &operator=(const ShaperTimer &) = delete;
    ShaperTimer &operator=(ShaperTimer &&) = delete;

    void scheduleSendPacket(typename Clock::time_point notBefore, Shaper *what);

private:
    void run();

    using T = std::pair<typename Clock::time_point, Shaper *>;
    std::priority_queue<T, folly::fbvector<T>> queue_;

    bool running_ = true;
    std::thread worker_;
    std::condition_variable nextWork_;
    std::mutex mtx_;
};

}  // namespace rtransfer

extern template class rtransfer::ShaperTimer<std::chrono::steady_clock>;
extern template class rtransfer::ShaperTimer<
    std::chrono::high_resolution_clock>;
