#pragma once

#include <folly/FBVector.h>

#include <queue>
#include <utility>

namespace rtransfer {

template <typename T, typename Hash = std::hash<typename T::value_type>>
class Buckets {
public:
    Buckets(const std::size_t buckets)
        : used_(buckets, false)
        , array_(buckets)
    {
    }

    T &get(std::size_t idx) { return array_[idx]; }

    void use(std::size_t idx) { used_[idx] = true; }

    bool isUsed(std::size_t idx) { return used_[idx]; }

    void stopUsing(std::size_t idx) { used_[idx] = false; }

    std::size_t bucket(const typename T::value_type &val)
    {
        return Hash{}(val) % array_.size();
    }

private:
    folly::fbvector<bool> used_;
    folly::fbvector<T> array_;
};

}  // namespace rtransfer
